#!/bin/bash
#Function Definitions

#Check if Finale DMG is mounted
check1 () {
echo "Looking for any mounted Finale disk image..."
if [ -a /Volumes/Finale ];then
  echo "Finale disk image found. Beginning silent install. Please enter your password to continue..."
  installSilently
else
  echo "Could not open MacDiskInstaller disk image. Looking for mounted Finale disk image anyway..."
  sleep 1
  echo "."
  sleep 1
  echo "."
  sleep 1
  echo "."
  sleep 1
  echo "."
  sleep 1
  echo "."
  sleep 1
  check2
fi
}

#Secondary check for Finale DMG
check2 () {
  if [ -a /Volumes/Finale ];then
    echo "Finale disk image found. Running silent install. Please enter your password to continue..."
    installSilently
  else
    choices
  fi
}

#Used to prompt for user input and avoid infinite loops
choices () {
  echo "It appears that the DMG for the Finale installer is not mounted."
  echo "Please ensure that the 'MacDiskInstaller...' DMG for Finale is in the "FinSI_Components" folder and then press 1 to try again. You can press 2 to terminate the process if needed."
  read -n 1 -p "What would you like to do?: " choice
  if [ "$choice" = "1" ]; then
    echo $'\n'
    main
  elif [ "$choice" = "2" ];then
    echo $'\n'
    echo "The silent install process will now close."
    sleep 2
    exit
  else
    echo $'\n'
    echo "Please choose to either run the silent installer again (1) or terminate the process (2)"
    choices
  fi
}

#Installs Finale silently
installSilently () {
  sudo installer -pkg /Volumes/Finale/Install\ Finale.pkg -target / -applyChoiceChangesXML "$(dirname "$0")"/silentInstallerChoices.plist
  sudo installer -pkg /Volumes/Finale/External/Garritan_ARIA_Player.pkg -target /
  sudo installer -pkg /Volumes/Finale/External/Garritan_Instruments_for_Finale.pkg -target /
  hdiutil detach /Volumes/Finale
  echo "The Finale installer is complete."
}

#ScriptMain
main () {
echo "Attempting to open Finale DMG from $(dirname "$0")..."
hdiutil attach "$(dirname "$0")"/MacDiskInstaller_25.4.0.*.dmg
check1
}

main
